package com.ejie.ab04b.service;
import com.ejie.ab04b.dao.VdatosReqApeDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VdatosReqApe;

/**
 * VdatosReqApeServiceImpl generated by UDA, 20-jun-2017 10:36:48.
 * @author UDA
 */

@Service(value = "vdatosReqApeService")
public class VdatosReqApeServiceImpl implements VdatosReqApeService {

	@Autowired
	private VdatosReqApeDao vdatosReqApeDao;

	/**
	 * Inserts a single row in the VdatosReqApe table.
	 * 
	 *  vdatosReqApe VdatosReqApe
	 *  VdatosReqApe
	 *
	 * @param vdatosReqApe the vdatos req ape
	 * @return the vdatos req ape
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdatosReqApe add(VdatosReqApe vdatosReqApe) {
		return this.vdatosReqApeDao.add(vdatosReqApe);
	}

	/**
	 * Updates a single row in the VdatosReqApe table.
	 * 
	 *  vdatosReqApe VdatosReqApe
	 *  VdatosReqApe
	 *
	 * @param vdatosReqApe the vdatos req ape
	 * @return the vdatos req ape
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdatosReqApe update(VdatosReqApe vdatosReqApe) {
		return this.vdatosReqApeDao.update(vdatosReqApe);
	 }

	/**
	 * Finds a single row in the VdatosReqApe table.
	 * 
	 *  vdatosReqApe VdatosReqApe
	 *  VdatosReqApe
	 *
	 * @param vdatosReqApe the vdatos req ape
	 * @return the vdatos req ape
	 */
	public VdatosReqApe find(VdatosReqApe vdatosReqApe) {
		return (VdatosReqApe) this.vdatosReqApeDao.find(vdatosReqApe);
	}
	
	/**
	 * Deletes a single row in the VdatosReqApe table.
	 * 
	 *  vdatosReqApe VdatosReqApe
	 *
	 * @param vdatosReqApe the vdatos req ape
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VdatosReqApe vdatosReqApe) {
		this.vdatosReqApeDao.remove(vdatosReqApe);
	}

	/**
	 * Finds a list of rows in the VdatosReqApe table.
	 * 
	 *  vdatosReqApe VdatosReqApe
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<VdatosReqApe>
	 *
	 * @param vdatosReqApe the vdatos req ape
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VdatosReqApe> findAll(VdatosReqApe vdatosReqApe, JQGridRequestDto jqGridRequestDto){
		return (List<VdatosReqApe>) this.vdatosReqApeDao.findAll(vdatosReqApe, jqGridRequestDto);
	}
    
	/**
	 * Finds rows in the VdatosReqApe table using like.
	 * 
	 *  vdatosReqApe VdatosReqApe
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean	 
	 *  List<VdatosReqApe>
	 *
	 * @param vdatosReqApe the vdatos req ape
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VdatosReqApe> findAllLike(VdatosReqApe vdatosReqApe, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return (List<VdatosReqApe>) this.vdatosReqApeDao.findAllLike(vdatosReqApe, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	 
	/**
	 * Removes rows from the VdatosReqApe table.
	 * 
	 *  filterVdatosReqApe VdatosReqApe
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *
	 * @param filterVdatosReqApe the filter vdatos req ape
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */	
	public void removeMultiple(VdatosReqApe filterVdatosReqApe, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		this.vdatosReqApeDao.removeMultiple(filterVdatosReqApe, jqGridRequestDto, startsWith);
	}
        
	/**
	 * Filter method in the VdatosReqApe table.
	 * 
	 *  filterVdatosReqApe VdatosReqApe
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  JQGridResponseDto<VdatosReqApe>
	 *
	 * @param filterVdatosReqApe the filter vdatos req ape
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */	
	public JQGridResponseDto< VdatosReqApe> filter(VdatosReqApe filterVdatosReqApe, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		List<VdatosReqApe> listaVdatosReqApe =  this.vdatosReqApeDao.findAllLike(filterVdatosReqApe, jqGridRequestDto, false);
		Long recordNum =  this.vdatosReqApeDao.findAllLikeCount(filterVdatosReqApe != null ? filterVdatosReqApe: new VdatosReqApe (),false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds()!=null){
			List< TableRowDto< VdatosReqApe>> reorderSelection = this.vdatosReqApeDao.reorderSelection(filterVdatosReqApe, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<VdatosReqApe>(jqGridRequestDto, recordNum, listaVdatosReqApe, reorderSelection);
		}
		return new JQGridResponseDto<VdatosReqApe>(jqGridRequestDto, recordNum, listaVdatosReqApe);   
	}
    
    /**
     * Searches rows in the VdatosReqApe table.
     * 
     *  filterVdatosReqApe VdatosReqApe
     *  searchVdatosReqApe VdatosReqApe
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  List<TableRowDto<VdatosReqApe>>
     *
     * @param filterVdatosReqApe the filter vdatos req ape
     * @param searchVdatosReqApe the search vdatos req ape
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the list
     */	
    public List< TableRowDto< VdatosReqApe>> search(VdatosReqApe filterVdatosReqApe, VdatosReqApe searchVdatosReqApe, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.vdatosReqApeDao.search(filterVdatosReqApe, searchVdatosReqApe, jqGridRequestDto, startsWith);
	}
    
    /**
     * Reorder the selection made in VdatosReqApe table.
     * 
     *  filterVdatosReqApe VdatosReqApe
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  Object
     *
     * @param filterVdatosReqApe the filter vdatos req ape
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the object
     */	
    public Object reorderSelection(VdatosReqApe filterVdatosReqApe, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.vdatosReqApeDao.reorderSelection(filterVdatosReqApe, jqGridRequestDto, startsWith);
	}
    
    /*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */
	 
	/**
     * Finder method in the hierarchical the VdatosReqApe table.
     * 
     *  filterVdatosReqApe VdatosReqApe
     *  jqGridRequestDto JQGridRequestDto
     *  startsWith Boolean
     *  JQGridResponseDto<JerarquiaDto<VdatosReqApe>>
     *
     * @param filterVdatosReqApe the filter vdatos req ape
     * @param jqGridRequestDto the jq grid request dto
     * @param startsWith the starts with
     * @return the JQ grid response dto
     */	
	public JQGridResponseDto<JerarquiaDto<VdatosReqApe>> jerarquia(VdatosReqApe filterVdatosReqApe, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		List<JerarquiaDto<VdatosReqApe>> listaVdatosReqApe =  this.vdatosReqApeDao.findAllLikeJerarquia(filterVdatosReqApe, jqGridRequestDto);
		Long recordNum = this.vdatosReqApeDao.findAllLikeCountJerarquia(filterVdatosReqApe, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<VdatosReqApe>>(jqGridRequestDto, recordNum, listaVdatosReqApe);
	}
	
	/**
	 * Finder method for siblings rows in the hierarchical the VdatosReqApe table.
	 * 
	 *  filterVdatosReqApe VdatosReqApe
	 *  jqGridRequestDto JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<VdatosReqApe>>
	 *
	 * @param filterVdatosReqApe the filter vdatos req ape
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */	
	public JQGridResponseDto<JerarquiaDto<VdatosReqApe>> jerarquiaChildren(VdatosReqApe filterVdatosReqApe, JQGridRequestDto jqGridRequestDto){
		JQGridResponseDto<JerarquiaDto<VdatosReqApe>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<VdatosReqApe>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN, this.vdatosReqApeDao.findAllChild(filterVdatosReqApe, jqGridRequestDto));
		return jqGridResponseDto;
	}
	
	
}

